/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

// InactivePropertyHelper `width & height on ruby element` test cases.
export default [
  {
    info: "width is inactive on ruby element",
    property: "width",
    tagName: "ruby",
    rules: ["ruby { width: 10px; }"],
    isActive: false,
  },
  {
    info: "min-width is inactive on ruby element",
    property: "min-width",
    tagName: "ruby",
    rules: ["ruby { min-width: 10px; }"],
    isActive: false,
  },
  {
    info: "max-width is inactive on ruby element",
    property: "max-width",
    tagName: "ruby",
    rules: ["ruby { max-width: 10px; }"],
    isActive: false,
  },
  {
    info: "height is inactive on ruby element",
    property: "height",
    tagName: "ruby",
    rules: ["ruby { height: 10px; }"],
    isActive: false,
  },
  {
    info: "min-height is inactive on ruby element",
    property: "min-height",
    tagName: "ruby",
    rules: ["ruby { min-height: 10px; }"],
    isActive: false,
  },
  {
    info: "max-height is inactive on ruby element",
    property: "max-height",
    tagName: "ruby",
    rules: ["ruby { max-height: 10px; }"],
    isActive: false,
  },
  {
    info: "width is active on div element",
    property: "width",
    tagName: "div",
    rules: ["div { width: 10px; }"],
    isActive: true,
  },
  {
    info: "min-width is active on div element",
    property: "min-width",
    tagName: "div",
    rules: ["div { min-width: 10px; }"],
    isActive: true,
  },
  {
    info: "max-width is active on div element",
    property: "max-width",
    tagName: "div",
    rules: ["div { max-width: 10px; }"],
    isActive: true,
  },
  {
    info: "height is active on div element",
    property: "height",
    tagName: "div",
    rules: ["div { height: 10px; }"],
    isActive: true,
  },
  {
    info: "min-height is active on div element",
    property: "min-height",
    tagName: "div",
    rules: ["div { min-height: 10px; }"],
    isActive: true,
  },
  {
    info: "max-height is active on div element",
    property: "max-height",
    tagName: "div",
    rules: ["div { max-height: 10px; }"],
    isActive: true,
  },
  {
    info: "width is inactive on div element with display ruby",
    property: "width",
    tagName: "div",
    rules: ["div { width: 10px; display: ruby;}"],
    isActive: false,
  },
  {
    info: "height is inactive on div element with display ruby",
    property: "height",
    tagName: "div",
    rules: ["div { height: 10px; display: ruby;}"],
    isActive: false,
  },
  {
    info: "width is active on ruby element with display block",
    property: "width",
    tagName: "ruby",
    rules: ["ruby { width: 10px; display: block;}"],
    isActive: true,
  },
  {
    info: "height is active on ruby element with display block",
    property: "height",
    tagName: "ruby",
    rules: ["ruby { height: 10px; display: block;}"],
    isActive: true,
  },
  {
    info: "width is inactive on ruby-text element",
    property: "width",
    tagName: "rt",
    rules: ["rt { width: 10px;}"],
    isActive: false,
  },
  {
    info: "height is inactive on ruby-text element",
    property: "height",
    tagName: "rt",
    rules: ["rt { height: 10px;}"],
    isActive: false,
  },
  {
    info: "width is inactive on div elements with display ruby-text",
    property: "width",
    tagName: "div",
    rules: ["div { width: 10px; display: ruby-text;}"],
    isActive: false,
  },
  {
    info: "height is inactive on div elements with display ruby-text",
    property: "height",
    tagName: "div",
    rules: ["div { height: 10px; display: ruby-text;}"],
    isActive: false,
  },
];
